/*
 * 	sample5.t				version 1.0
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *  SAMPLE DEMONSTRATION GAME FOR SENSE.T
 *
 *  This file demonstrates the use of extended description attributes
 *  and the locale() function.
 *
 *  This file requires HTML TADS 2.5.1 or later.
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		25-Jan-00:	Creation.
 */

/* use the HTML status line and prompts */
#define USE_HTML_STATUS
#define USE_HTML_PROMPT
#define USE_CONTAINMENT

/* include the standard TADS libraries */
#include <adv.t>
#include <std.t>
#include <sense.t>

#pragma C+

/* at game startup, turn on HTML mode */
replace commonInit: function
{
    /* display the special code sequence to turn on HTML recognition */
    "\H+";
}

/* starting location */
startroom: room
    noun = 'lobby'
    adjective = 'theatre'
    isListed = nil
    isqVisible = true
    sdesc = "Theatre Lobby"
    sdesc_remote = "lobby"
    ldesc = "This room is a tribute to the now-faded glory of the
        theatre. The still-smiling faces of forgotten productions stare
        out from faded posters at you. An old grand staircase leads up,
        while the exit lies to the south. Small private doors lead
        northeast and northwest."
    ldesc_remote = "Below you is the theatre lobby."
    north = staircaseLanding
    up = staircaseLanding
    doInspect(actor) =
    {
            if (proximity(actor, self) == PRX_REMOTE)
            {
                "(Looking down)\n";
                locale(actor, self, &access_visible);
            }
            else pass doInspect;
    }
;

pager: item
    location = startroom
    noun = 'pager'
    adjective = 'your' 'my'
    sdesc = "your pager"
    adesc = "your pager"
    adesc_remote = "what appears to be your pager"
    thedesc = "the pager"
    ldesc_remote = "Your pager is barely recognisable from this
        distance."
;  

joe: Actor
    location = startroom
    noun = 'joe'
    sdesc = "Joe"
    adesc = "Joe"
    thedesc = "Joe"
    ldesc = {
        if (itemcnt(self.contents))
            "\^<<self.thedesc>> is carrying <<listcont(self)>>. ";
        else
            "\^<<self.thedesc>> appears to be empty-handed. ";
    }
    actorAction(v, d, p, i) = {}
;

staircaseLanding: room
    sdesc = "Staircase Landing"
    ldesc = "Here the grand staircase splits to the east and west. You
        can also go back down to the south."
    south = startroom
    east = easternLanding
    down = startroom
;

easternLanding: room
    sdesc = "Eastern Landing"
    ldesc = "This landing circles around the upper level of the lobby
        allowing you to see down into it. The landing continues south
        and west, where it goes down the lobby stairs. A set of double
        doors lead north to the theatre auditorium itself, while a
        single finely carved wooden door leads east."
    west = staircaseLanding
    seeInto = startroom
;
